module Data.List.Key.Private where

import Data.Function.HT (compose2, )

import qualified Data.List.Comparing as Cmp
import Data.List (nubBy, sortBy, minimumBy, maximumBy, )

import Prelude hiding (minimum, maximum, )

{- $setup
>>> import qualified Data.List.HT as ListHT
>>>
>>> import Test.QuickCheck ((===))
-}


attach :: (a -> b) -> [a] -> [(b,a)]
attach key = map (\x -> (key x, x))


aux ::
   (((key, a) -> (key, a) -> b) -> [(key, a)] -> c) ->
      (key -> key -> b) -> (a -> key) ->
          ([a] -> c)
aux listFunc cmpFunc key =
   listFunc (compose2 cmpFunc fst) . attach key


{- |
Divides a list into sublists such that the members in a sublist
share the same key.
It uses semantics of 'Data.List.HT.groupBy',
not that of 'Data.List.groupBy'.

prop> \xs -> group id xs === ListHT.group (xs :: [Ordering])
-}
group :: Eq b => (a -> b) -> [a] -> [[a]]
group key = map (map snd) . aux Cmp.group (==) key

{- | argmin -}
minimum :: Ord b => (a -> b) -> [a] -> a
minimum key  =  snd . aux minimumBy compare key

{- | argmax -}
maximum :: Ord b => (a -> b) -> [a] -> a
maximum key  =  snd . aux maximumBy compare key

sort :: Ord b => (a -> b) -> [a] -> [a]
sort key  =  map snd . aux sortBy compare key

merge :: Ord b => (a -> b) -> [a] -> [a] -> [a]
merge key xs ys  =
   map snd $
   Cmp.merge
      (compose2 (<=) fst)
      (attach key xs) (attach key ys)

nub :: Eq b => (a -> b) -> [a] -> [a]
nub key  =  map snd . aux nubBy (==) key
