module Data.List.Comparing where


{- $setup
>>> import Data.Eq.HT (equating)
>>>
>>> import Test.QuickCheck ((===))
-}

{- |
prop> \xs -> let equ = equating fst in group equ xs === groupEmpty equ (xs :: [(Ordering,Bool)])
prop> \xs -> let equ = equating snd in group equ xs === groupEmpty equ (xs :: [(Ordering,Bool)])
-}
group :: (a -> a -> Bool) -> [a] -> [[a]]
group p = map (uncurry (:)) . groupNonEmpty p

groupNonEmpty :: (a -> a -> Bool) -> [a] -> [(a,[a])]
groupNonEmpty p =
   foldr
      (\x0 yt ->
         let (xr,yr) =
               case yt of
                  (x1,xs):ys ->
                     if p x0 x1
                       then (x1:xs,ys)
                       else ([],yt)
                  [] -> ([],yt)
         in  (x0,xr):yr)
      []

groupEmpty :: (a -> a -> Bool) -> [a] -> [[a]]
groupEmpty p =
   init . uncurry (:) .
   foldr
      (\x0 ~(y,ys) ->
         if (case y of x1:_ -> p x0 x1; _ -> False)
           then (x0:y,ys)
           else (x0:[],y:ys))
      ([],[])

{- |
>>> null $ merge (<=) (undefined:"") (undefined:"")
False
-}
merge :: (a -> a -> Bool) -> [a] -> [a] -> [a]
merge p =
   let recourse [] yl = yl
       recourse xl [] = xl
       recourse xl@(x:xs) yl@(y:ys) =
         uncurry (:) $
         if p x y
           then (x, recourse xs yl)
           else (y, recourse xl ys)
   in  recourse
