module Stratosphere.WAF.SqlInjectionMatchSet.SqlInjectionMatchTupleProperty (
        module Exports, SqlInjectionMatchTupleProperty(..),
        mkSqlInjectionMatchTupleProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.WAF.SqlInjectionMatchSet.FieldToMatchProperty as Exports
import Stratosphere.ResourceProperties
import Stratosphere.Value
data SqlInjectionMatchTupleProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waf-sqlinjectionmatchset-sqlinjectionmatchtuples.html>
    SqlInjectionMatchTupleProperty {haddock_workaround_ :: (),
                                    -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waf-sqlinjectionmatchset-sqlinjectionmatchtuples.html#cfn-waf-sqlinjectionmatchset-sqlinjectionmatchtuples-fieldtomatch>
                                    fieldToMatch :: FieldToMatchProperty,
                                    -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waf-sqlinjectionmatchset-sqlinjectionmatchtuples.html#cfn-waf-sqlinjectionmatchset-sqlinjectionmatchtuples-texttransformation>
                                    textTransformation :: (Value Prelude.Text)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkSqlInjectionMatchTupleProperty ::
  FieldToMatchProperty
  -> Value Prelude.Text -> SqlInjectionMatchTupleProperty
mkSqlInjectionMatchTupleProperty fieldToMatch textTransformation
  = SqlInjectionMatchTupleProperty
      {haddock_workaround_ = (), fieldToMatch = fieldToMatch,
       textTransformation = textTransformation}
instance ToResourceProperties SqlInjectionMatchTupleProperty where
  toResourceProperties SqlInjectionMatchTupleProperty {..}
    = ResourceProperties
        {awsType = "AWS::WAF::SqlInjectionMatchSet.SqlInjectionMatchTuple",
         supportsTags = Prelude.False,
         properties = ["FieldToMatch" JSON..= fieldToMatch,
                       "TextTransformation" JSON..= textTransformation]}
instance JSON.ToJSON SqlInjectionMatchTupleProperty where
  toJSON SqlInjectionMatchTupleProperty {..}
    = JSON.object
        ["FieldToMatch" JSON..= fieldToMatch,
         "TextTransformation" JSON..= textTransformation]
instance Property "FieldToMatch" SqlInjectionMatchTupleProperty where
  type PropertyType "FieldToMatch" SqlInjectionMatchTupleProperty = FieldToMatchProperty
  set newValue SqlInjectionMatchTupleProperty {..}
    = SqlInjectionMatchTupleProperty {fieldToMatch = newValue, ..}
instance Property "TextTransformation" SqlInjectionMatchTupleProperty where
  type PropertyType "TextTransformation" SqlInjectionMatchTupleProperty = Value Prelude.Text
  set newValue SqlInjectionMatchTupleProperty {..}
    = SqlInjectionMatchTupleProperty
        {textTransformation = newValue, ..}