module Stratosphere.SSMIncidents.ResponsePlan.PagerDutyConfigurationProperty (
        module Exports, PagerDutyConfigurationProperty(..),
        mkPagerDutyConfigurationProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.SSMIncidents.ResponsePlan.PagerDutyIncidentConfigurationProperty as Exports
import Stratosphere.ResourceProperties
import Stratosphere.Value
data PagerDutyConfigurationProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmincidents-responseplan-pagerdutyconfiguration.html>
    PagerDutyConfigurationProperty {haddock_workaround_ :: (),
                                    -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmincidents-responseplan-pagerdutyconfiguration.html#cfn-ssmincidents-responseplan-pagerdutyconfiguration-name>
                                    name :: (Value Prelude.Text),
                                    -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmincidents-responseplan-pagerdutyconfiguration.html#cfn-ssmincidents-responseplan-pagerdutyconfiguration-pagerdutyincidentconfiguration>
                                    pagerDutyIncidentConfiguration :: PagerDutyIncidentConfigurationProperty,
                                    -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmincidents-responseplan-pagerdutyconfiguration.html#cfn-ssmincidents-responseplan-pagerdutyconfiguration-secretid>
                                    secretId :: (Value Prelude.Text)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkPagerDutyConfigurationProperty ::
  Value Prelude.Text
  -> PagerDutyIncidentConfigurationProperty
     -> Value Prelude.Text -> PagerDutyConfigurationProperty
mkPagerDutyConfigurationProperty
  name
  pagerDutyIncidentConfiguration
  secretId
  = PagerDutyConfigurationProperty
      {haddock_workaround_ = (), name = name,
       pagerDutyIncidentConfiguration = pagerDutyIncidentConfiguration,
       secretId = secretId}
instance ToResourceProperties PagerDutyConfigurationProperty where
  toResourceProperties PagerDutyConfigurationProperty {..}
    = ResourceProperties
        {awsType = "AWS::SSMIncidents::ResponsePlan.PagerDutyConfiguration",
         supportsTags = Prelude.False,
         properties = ["Name" JSON..= name,
                       "PagerDutyIncidentConfiguration"
                         JSON..= pagerDutyIncidentConfiguration,
                       "SecretId" JSON..= secretId]}
instance JSON.ToJSON PagerDutyConfigurationProperty where
  toJSON PagerDutyConfigurationProperty {..}
    = JSON.object
        ["Name" JSON..= name,
         "PagerDutyIncidentConfiguration"
           JSON..= pagerDutyIncidentConfiguration,
         "SecretId" JSON..= secretId]
instance Property "Name" PagerDutyConfigurationProperty where
  type PropertyType "Name" PagerDutyConfigurationProperty = Value Prelude.Text
  set newValue PagerDutyConfigurationProperty {..}
    = PagerDutyConfigurationProperty {name = newValue, ..}
instance Property "PagerDutyIncidentConfiguration" PagerDutyConfigurationProperty where
  type PropertyType "PagerDutyIncidentConfiguration" PagerDutyConfigurationProperty = PagerDutyIncidentConfigurationProperty
  set newValue PagerDutyConfigurationProperty {..}
    = PagerDutyConfigurationProperty
        {pagerDutyIncidentConfiguration = newValue, ..}
instance Property "SecretId" PagerDutyConfigurationProperty where
  type PropertyType "SecretId" PagerDutyConfigurationProperty = Value Prelude.Text
  set newValue PagerDutyConfigurationProperty {..}
    = PagerDutyConfigurationProperty {secretId = newValue, ..}