module Stratosphere.QuickSight.Template.TemplateSourceAnalysisProperty (
        module Exports, TemplateSourceAnalysisProperty(..),
        mkTemplateSourceAnalysisProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.QuickSight.Template.DataSetReferenceProperty as Exports
import Stratosphere.ResourceProperties
import Stratosphere.Value
data TemplateSourceAnalysisProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceanalysis.html>
    TemplateSourceAnalysisProperty {haddock_workaround_ :: (),
                                    -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceanalysis.html#cfn-quicksight-template-templatesourceanalysis-arn>
                                    arn :: (Value Prelude.Text),
                                    -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceanalysis.html#cfn-quicksight-template-templatesourceanalysis-datasetreferences>
                                    dataSetReferences :: [DataSetReferenceProperty]}
  deriving stock (Prelude.Eq, Prelude.Show)
mkTemplateSourceAnalysisProperty ::
  Value Prelude.Text
  -> [DataSetReferenceProperty] -> TemplateSourceAnalysisProperty
mkTemplateSourceAnalysisProperty arn dataSetReferences
  = TemplateSourceAnalysisProperty
      {haddock_workaround_ = (), arn = arn,
       dataSetReferences = dataSetReferences}
instance ToResourceProperties TemplateSourceAnalysisProperty where
  toResourceProperties TemplateSourceAnalysisProperty {..}
    = ResourceProperties
        {awsType = "AWS::QuickSight::Template.TemplateSourceAnalysis",
         supportsTags = Prelude.False,
         properties = ["Arn" JSON..= arn,
                       "DataSetReferences" JSON..= dataSetReferences]}
instance JSON.ToJSON TemplateSourceAnalysisProperty where
  toJSON TemplateSourceAnalysisProperty {..}
    = JSON.object
        ["Arn" JSON..= arn, "DataSetReferences" JSON..= dataSetReferences]
instance Property "Arn" TemplateSourceAnalysisProperty where
  type PropertyType "Arn" TemplateSourceAnalysisProperty = Value Prelude.Text
  set newValue TemplateSourceAnalysisProperty {..}
    = TemplateSourceAnalysisProperty {arn = newValue, ..}
instance Property "DataSetReferences" TemplateSourceAnalysisProperty where
  type PropertyType "DataSetReferences" TemplateSourceAnalysisProperty = [DataSetReferenceProperty]
  set newValue TemplateSourceAnalysisProperty {..}
    = TemplateSourceAnalysisProperty {dataSetReferences = newValue, ..}