module Stratosphere.QBusiness.Plugin (
        module Exports, Plugin(..), mkPlugin
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.QBusiness.Plugin.CustomPluginConfigurationProperty as Exports
import {-# SOURCE #-} Stratosphere.QBusiness.Plugin.PluginAuthConfigurationProperty as Exports
import Stratosphere.ResourceProperties
import Stratosphere.Tag
import Stratosphere.Value
data Plugin
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html>
    Plugin {haddock_workaround_ :: (),
            -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-applicationid>
            applicationId :: (Prelude.Maybe (Value Prelude.Text)),
            -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-authconfiguration>
            authConfiguration :: PluginAuthConfigurationProperty,
            -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-custompluginconfiguration>
            customPluginConfiguration :: (Prelude.Maybe CustomPluginConfigurationProperty),
            -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-displayname>
            displayName :: (Value Prelude.Text),
            -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-serverurl>
            serverUrl :: (Prelude.Maybe (Value Prelude.Text)),
            -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-state>
            state :: (Prelude.Maybe (Value Prelude.Text)),
            -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-tags>
            tags :: (Prelude.Maybe [Tag]),
            -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-type>
            type' :: (Value Prelude.Text)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkPlugin ::
  PluginAuthConfigurationProperty
  -> Value Prelude.Text -> Value Prelude.Text -> Plugin
mkPlugin authConfiguration displayName type'
  = Plugin
      {haddock_workaround_ = (), authConfiguration = authConfiguration,
       displayName = displayName, type' = type',
       applicationId = Prelude.Nothing,
       customPluginConfiguration = Prelude.Nothing,
       serverUrl = Prelude.Nothing, state = Prelude.Nothing,
       tags = Prelude.Nothing}
instance ToResourceProperties Plugin where
  toResourceProperties Plugin {..}
    = ResourceProperties
        {awsType = "AWS::QBusiness::Plugin", supportsTags = Prelude.True,
         properties = Prelude.fromList
                        ((Prelude.<>)
                           ["AuthConfiguration" JSON..= authConfiguration,
                            "DisplayName" JSON..= displayName, "Type" JSON..= type']
                           (Prelude.catMaybes
                              [(JSON..=) "ApplicationId" Prelude.<$> applicationId,
                               (JSON..=) "CustomPluginConfiguration"
                                 Prelude.<$> customPluginConfiguration,
                               (JSON..=) "ServerUrl" Prelude.<$> serverUrl,
                               (JSON..=) "State" Prelude.<$> state,
                               (JSON..=) "Tags" Prelude.<$> tags]))}
instance JSON.ToJSON Plugin where
  toJSON Plugin {..}
    = JSON.object
        (Prelude.fromList
           ((Prelude.<>)
              ["AuthConfiguration" JSON..= authConfiguration,
               "DisplayName" JSON..= displayName, "Type" JSON..= type']
              (Prelude.catMaybes
                 [(JSON..=) "ApplicationId" Prelude.<$> applicationId,
                  (JSON..=) "CustomPluginConfiguration"
                    Prelude.<$> customPluginConfiguration,
                  (JSON..=) "ServerUrl" Prelude.<$> serverUrl,
                  (JSON..=) "State" Prelude.<$> state,
                  (JSON..=) "Tags" Prelude.<$> tags])))
instance Property "ApplicationId" Plugin where
  type PropertyType "ApplicationId" Plugin = Value Prelude.Text
  set newValue Plugin {..}
    = Plugin {applicationId = Prelude.pure newValue, ..}
instance Property "AuthConfiguration" Plugin where
  type PropertyType "AuthConfiguration" Plugin = PluginAuthConfigurationProperty
  set newValue Plugin {..}
    = Plugin {authConfiguration = newValue, ..}
instance Property "CustomPluginConfiguration" Plugin where
  type PropertyType "CustomPluginConfiguration" Plugin = CustomPluginConfigurationProperty
  set newValue Plugin {..}
    = Plugin {customPluginConfiguration = Prelude.pure newValue, ..}
instance Property "DisplayName" Plugin where
  type PropertyType "DisplayName" Plugin = Value Prelude.Text
  set newValue Plugin {..} = Plugin {displayName = newValue, ..}
instance Property "ServerUrl" Plugin where
  type PropertyType "ServerUrl" Plugin = Value Prelude.Text
  set newValue Plugin {..}
    = Plugin {serverUrl = Prelude.pure newValue, ..}
instance Property "State" Plugin where
  type PropertyType "State" Plugin = Value Prelude.Text
  set newValue Plugin {..}
    = Plugin {state = Prelude.pure newValue, ..}
instance Property "Tags" Plugin where
  type PropertyType "Tags" Plugin = [Tag]
  set newValue Plugin {..}
    = Plugin {tags = Prelude.pure newValue, ..}
instance Property "Type" Plugin where
  type PropertyType "Type" Plugin = Value Prelude.Text
  set newValue Plugin {..} = Plugin {type' = newValue, ..}