module Stratosphere.M2.Environment.EfsStorageConfigurationProperty (
        EfsStorageConfigurationProperty(..),
        mkEfsStorageConfigurationProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Value
data EfsStorageConfigurationProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-m2-environment-efsstorageconfiguration.html>
    EfsStorageConfigurationProperty {haddock_workaround_ :: (),
                                     -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-m2-environment-efsstorageconfiguration.html#cfn-m2-environment-efsstorageconfiguration-filesystemid>
                                     fileSystemId :: (Value Prelude.Text),
                                     -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-m2-environment-efsstorageconfiguration.html#cfn-m2-environment-efsstorageconfiguration-mountpoint>
                                     mountPoint :: (Value Prelude.Text)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkEfsStorageConfigurationProperty ::
  Value Prelude.Text
  -> Value Prelude.Text -> EfsStorageConfigurationProperty
mkEfsStorageConfigurationProperty fileSystemId mountPoint
  = EfsStorageConfigurationProperty
      {haddock_workaround_ = (), fileSystemId = fileSystemId,
       mountPoint = mountPoint}
instance ToResourceProperties EfsStorageConfigurationProperty where
  toResourceProperties EfsStorageConfigurationProperty {..}
    = ResourceProperties
        {awsType = "AWS::M2::Environment.EfsStorageConfiguration",
         supportsTags = Prelude.False,
         properties = ["FileSystemId" JSON..= fileSystemId,
                       "MountPoint" JSON..= mountPoint]}
instance JSON.ToJSON EfsStorageConfigurationProperty where
  toJSON EfsStorageConfigurationProperty {..}
    = JSON.object
        ["FileSystemId" JSON..= fileSystemId,
         "MountPoint" JSON..= mountPoint]
instance Property "FileSystemId" EfsStorageConfigurationProperty where
  type PropertyType "FileSystemId" EfsStorageConfigurationProperty = Value Prelude.Text
  set newValue EfsStorageConfigurationProperty {..}
    = EfsStorageConfigurationProperty {fileSystemId = newValue, ..}
instance Property "MountPoint" EfsStorageConfigurationProperty where
  type PropertyType "MountPoint" EfsStorageConfigurationProperty = Value Prelude.Text
  set newValue EfsStorageConfigurationProperty {..}
    = EfsStorageConfigurationProperty {mountPoint = newValue, ..}