module Stratosphere.LookoutMetrics.AnomalyDetector.RDSSourceConfigProperty (
        module Exports, RDSSourceConfigProperty(..),
        mkRDSSourceConfigProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.LookoutMetrics.AnomalyDetector.VpcConfigurationProperty as Exports
import Stratosphere.ResourceProperties
import Stratosphere.Value
data RDSSourceConfigProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html>
    RDSSourceConfigProperty {haddock_workaround_ :: (),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-dbinstanceidentifier>
                             dBInstanceIdentifier :: (Value Prelude.Text),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-databasehost>
                             databaseHost :: (Value Prelude.Text),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-databasename>
                             databaseName :: (Value Prelude.Text),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-databaseport>
                             databasePort :: (Value Prelude.Integer),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-rolearn>
                             roleArn :: (Value Prelude.Text),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-secretmanagerarn>
                             secretManagerArn :: (Value Prelude.Text),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-tablename>
                             tableName :: (Value Prelude.Text),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-vpcconfiguration>
                             vpcConfiguration :: VpcConfigurationProperty}
  deriving stock (Prelude.Eq, Prelude.Show)
mkRDSSourceConfigProperty ::
  Value Prelude.Text
  -> Value Prelude.Text
     -> Value Prelude.Text
        -> Value Prelude.Integer
           -> Value Prelude.Text
              -> Value Prelude.Text
                 -> Value Prelude.Text
                    -> VpcConfigurationProperty -> RDSSourceConfigProperty
mkRDSSourceConfigProperty
  dBInstanceIdentifier
  databaseHost
  databaseName
  databasePort
  roleArn
  secretManagerArn
  tableName
  vpcConfiguration
  = RDSSourceConfigProperty
      {haddock_workaround_ = (),
       dBInstanceIdentifier = dBInstanceIdentifier,
       databaseHost = databaseHost, databaseName = databaseName,
       databasePort = databasePort, roleArn = roleArn,
       secretManagerArn = secretManagerArn, tableName = tableName,
       vpcConfiguration = vpcConfiguration}
instance ToResourceProperties RDSSourceConfigProperty where
  toResourceProperties RDSSourceConfigProperty {..}
    = ResourceProperties
        {awsType = "AWS::LookoutMetrics::AnomalyDetector.RDSSourceConfig",
         supportsTags = Prelude.False,
         properties = ["DBInstanceIdentifier" JSON..= dBInstanceIdentifier,
                       "DatabaseHost" JSON..= databaseHost,
                       "DatabaseName" JSON..= databaseName,
                       "DatabasePort" JSON..= databasePort, "RoleArn" JSON..= roleArn,
                       "SecretManagerArn" JSON..= secretManagerArn,
                       "TableName" JSON..= tableName,
                       "VpcConfiguration" JSON..= vpcConfiguration]}
instance JSON.ToJSON RDSSourceConfigProperty where
  toJSON RDSSourceConfigProperty {..}
    = JSON.object
        ["DBInstanceIdentifier" JSON..= dBInstanceIdentifier,
         "DatabaseHost" JSON..= databaseHost,
         "DatabaseName" JSON..= databaseName,
         "DatabasePort" JSON..= databasePort, "RoleArn" JSON..= roleArn,
         "SecretManagerArn" JSON..= secretManagerArn,
         "TableName" JSON..= tableName,
         "VpcConfiguration" JSON..= vpcConfiguration]
instance Property "DBInstanceIdentifier" RDSSourceConfigProperty where
  type PropertyType "DBInstanceIdentifier" RDSSourceConfigProperty = Value Prelude.Text
  set newValue RDSSourceConfigProperty {..}
    = RDSSourceConfigProperty {dBInstanceIdentifier = newValue, ..}
instance Property "DatabaseHost" RDSSourceConfigProperty where
  type PropertyType "DatabaseHost" RDSSourceConfigProperty = Value Prelude.Text
  set newValue RDSSourceConfigProperty {..}
    = RDSSourceConfigProperty {databaseHost = newValue, ..}
instance Property "DatabaseName" RDSSourceConfigProperty where
  type PropertyType "DatabaseName" RDSSourceConfigProperty = Value Prelude.Text
  set newValue RDSSourceConfigProperty {..}
    = RDSSourceConfigProperty {databaseName = newValue, ..}
instance Property "DatabasePort" RDSSourceConfigProperty where
  type PropertyType "DatabasePort" RDSSourceConfigProperty = Value Prelude.Integer
  set newValue RDSSourceConfigProperty {..}
    = RDSSourceConfigProperty {databasePort = newValue, ..}
instance Property "RoleArn" RDSSourceConfigProperty where
  type PropertyType "RoleArn" RDSSourceConfigProperty = Value Prelude.Text
  set newValue RDSSourceConfigProperty {..}
    = RDSSourceConfigProperty {roleArn = newValue, ..}
instance Property "SecretManagerArn" RDSSourceConfigProperty where
  type PropertyType "SecretManagerArn" RDSSourceConfigProperty = Value Prelude.Text
  set newValue RDSSourceConfigProperty {..}
    = RDSSourceConfigProperty {secretManagerArn = newValue, ..}
instance Property "TableName" RDSSourceConfigProperty where
  type PropertyType "TableName" RDSSourceConfigProperty = Value Prelude.Text
  set newValue RDSSourceConfigProperty {..}
    = RDSSourceConfigProperty {tableName = newValue, ..}
instance Property "VpcConfiguration" RDSSourceConfigProperty where
  type PropertyType "VpcConfiguration" RDSSourceConfigProperty = VpcConfigurationProperty
  set newValue RDSSourceConfigProperty {..}
    = RDSSourceConfigProperty {vpcConfiguration = newValue, ..}