module Stratosphere.KafkaConnect.Connector.KafkaClusterClientAuthenticationProperty (
        KafkaClusterClientAuthenticationProperty(..),
        mkKafkaClusterClientAuthenticationProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Value
data KafkaClusterClientAuthenticationProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-kafkaclusterclientauthentication.html>
    KafkaClusterClientAuthenticationProperty {haddock_workaround_ :: (),
                                              -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-kafkaclusterclientauthentication.html#cfn-kafkaconnect-connector-kafkaclusterclientauthentication-authenticationtype>
                                              authenticationType :: (Value Prelude.Text)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkKafkaClusterClientAuthenticationProperty ::
  Value Prelude.Text -> KafkaClusterClientAuthenticationProperty
mkKafkaClusterClientAuthenticationProperty authenticationType
  = KafkaClusterClientAuthenticationProperty
      {haddock_workaround_ = (), authenticationType = authenticationType}
instance ToResourceProperties KafkaClusterClientAuthenticationProperty where
  toResourceProperties KafkaClusterClientAuthenticationProperty {..}
    = ResourceProperties
        {awsType = "AWS::KafkaConnect::Connector.KafkaClusterClientAuthentication",
         supportsTags = Prelude.False,
         properties = ["AuthenticationType" JSON..= authenticationType]}
instance JSON.ToJSON KafkaClusterClientAuthenticationProperty where
  toJSON KafkaClusterClientAuthenticationProperty {..}
    = JSON.object ["AuthenticationType" JSON..= authenticationType]
instance Property "AuthenticationType" KafkaClusterClientAuthenticationProperty where
  type PropertyType "AuthenticationType" KafkaClusterClientAuthenticationProperty = Value Prelude.Text
  set newValue KafkaClusterClientAuthenticationProperty {..}
    = KafkaClusterClientAuthenticationProperty
        {authenticationType = newValue, ..}