module Stratosphere.GuardDuty.MalwareProtectionPlan.CFNStatusReasonsProperty (
        CFNStatusReasonsProperty(..), mkCFNStatusReasonsProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Value
data CFNStatusReasonsProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-malwareprotectionplan-cfnstatusreasons.html>
    CFNStatusReasonsProperty {haddock_workaround_ :: (),
                              -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-malwareprotectionplan-cfnstatusreasons.html#cfn-guardduty-malwareprotectionplan-cfnstatusreasons-code>
                              code :: (Prelude.Maybe (Value Prelude.Text)),
                              -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-malwareprotectionplan-cfnstatusreasons.html#cfn-guardduty-malwareprotectionplan-cfnstatusreasons-message>
                              message :: (Prelude.Maybe (Value Prelude.Text))}
  deriving stock (Prelude.Eq, Prelude.Show)
mkCFNStatusReasonsProperty :: CFNStatusReasonsProperty
mkCFNStatusReasonsProperty
  = CFNStatusReasonsProperty
      {haddock_workaround_ = (), code = Prelude.Nothing,
       message = Prelude.Nothing}
instance ToResourceProperties CFNStatusReasonsProperty where
  toResourceProperties CFNStatusReasonsProperty {..}
    = ResourceProperties
        {awsType = "AWS::GuardDuty::MalwareProtectionPlan.CFNStatusReasons",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes
                           [(JSON..=) "Code" Prelude.<$> code,
                            (JSON..=) "Message" Prelude.<$> message])}
instance JSON.ToJSON CFNStatusReasonsProperty where
  toJSON CFNStatusReasonsProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes
              [(JSON..=) "Code" Prelude.<$> code,
               (JSON..=) "Message" Prelude.<$> message]))
instance Property "Code" CFNStatusReasonsProperty where
  type PropertyType "Code" CFNStatusReasonsProperty = Value Prelude.Text
  set newValue CFNStatusReasonsProperty {..}
    = CFNStatusReasonsProperty {code = Prelude.pure newValue, ..}
instance Property "Message" CFNStatusReasonsProperty where
  type PropertyType "Message" CFNStatusReasonsProperty = Value Prelude.Text
  set newValue CFNStatusReasonsProperty {..}
    = CFNStatusReasonsProperty {message = Prelude.pure newValue, ..}