module Stratosphere.GuardDuty.MalwareProtectionPlan.CFNProtectedResourceProperty (
        module Exports, CFNProtectedResourceProperty(..),
        mkCFNProtectedResourceProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.GuardDuty.MalwareProtectionPlan.S3BucketProperty as Exports
import Stratosphere.ResourceProperties
data CFNProtectedResourceProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-malwareprotectionplan-cfnprotectedresource.html>
    CFNProtectedResourceProperty {haddock_workaround_ :: (),
                                  -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-malwareprotectionplan-cfnprotectedresource.html#cfn-guardduty-malwareprotectionplan-cfnprotectedresource-s3bucket>
                                  s3Bucket :: S3BucketProperty}
  deriving stock (Prelude.Eq, Prelude.Show)
mkCFNProtectedResourceProperty ::
  S3BucketProperty -> CFNProtectedResourceProperty
mkCFNProtectedResourceProperty s3Bucket
  = CFNProtectedResourceProperty
      {haddock_workaround_ = (), s3Bucket = s3Bucket}
instance ToResourceProperties CFNProtectedResourceProperty where
  toResourceProperties CFNProtectedResourceProperty {..}
    = ResourceProperties
        {awsType = "AWS::GuardDuty::MalwareProtectionPlan.CFNProtectedResource",
         supportsTags = Prelude.False,
         properties = ["S3Bucket" JSON..= s3Bucket]}
instance JSON.ToJSON CFNProtectedResourceProperty where
  toJSON CFNProtectedResourceProperty {..}
    = JSON.object ["S3Bucket" JSON..= s3Bucket]
instance Property "S3Bucket" CFNProtectedResourceProperty where
  type PropertyType "S3Bucket" CFNProtectedResourceProperty = S3BucketProperty
  set newValue CFNProtectedResourceProperty {..}
    = CFNProtectedResourceProperty {s3Bucket = newValue, ..}