module Stratosphere.GuardDuty.MalwareProtectionPlan.CFNActionsProperty (
        module Exports, CFNActionsProperty(..), mkCFNActionsProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.GuardDuty.MalwareProtectionPlan.CFNTaggingProperty as Exports
import Stratosphere.ResourceProperties
data CFNActionsProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-malwareprotectionplan-cfnactions.html>
    CFNActionsProperty {haddock_workaround_ :: (),
                        -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-malwareprotectionplan-cfnactions.html#cfn-guardduty-malwareprotectionplan-cfnactions-tagging>
                        tagging :: (Prelude.Maybe CFNTaggingProperty)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkCFNActionsProperty :: CFNActionsProperty
mkCFNActionsProperty
  = CFNActionsProperty
      {haddock_workaround_ = (), tagging = Prelude.Nothing}
instance ToResourceProperties CFNActionsProperty where
  toResourceProperties CFNActionsProperty {..}
    = ResourceProperties
        {awsType = "AWS::GuardDuty::MalwareProtectionPlan.CFNActions",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes [(JSON..=) "Tagging" Prelude.<$> tagging])}
instance JSON.ToJSON CFNActionsProperty where
  toJSON CFNActionsProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes [(JSON..=) "Tagging" Prelude.<$> tagging]))
instance Property "Tagging" CFNActionsProperty where
  type PropertyType "Tagging" CFNActionsProperty = CFNTaggingProperty
  set newValue CFNActionsProperty {..}
    = CFNActionsProperty {tagging = Prelude.pure newValue, ..}