module Stratosphere.GuardDuty.Detector.CFNMalwareProtectionConfigurationProperty (
        module Exports, CFNMalwareProtectionConfigurationProperty(..),
        mkCFNMalwareProtectionConfigurationProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.GuardDuty.Detector.CFNScanEc2InstanceWithFindingsConfigurationProperty as Exports
import Stratosphere.ResourceProperties
data CFNMalwareProtectionConfigurationProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-detector-cfnmalwareprotectionconfiguration.html>
    CFNMalwareProtectionConfigurationProperty {haddock_workaround_ :: (),
                                               -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-detector-cfnmalwareprotectionconfiguration.html#cfn-guardduty-detector-cfnmalwareprotectionconfiguration-scanec2instancewithfindings>
                                               scanEc2InstanceWithFindings :: (Prelude.Maybe CFNScanEc2InstanceWithFindingsConfigurationProperty)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkCFNMalwareProtectionConfigurationProperty ::
  CFNMalwareProtectionConfigurationProperty
mkCFNMalwareProtectionConfigurationProperty
  = CFNMalwareProtectionConfigurationProperty
      {haddock_workaround_ = (),
       scanEc2InstanceWithFindings = Prelude.Nothing}
instance ToResourceProperties CFNMalwareProtectionConfigurationProperty where
  toResourceProperties CFNMalwareProtectionConfigurationProperty {..}
    = ResourceProperties
        {awsType = "AWS::GuardDuty::Detector.CFNMalwareProtectionConfiguration",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes
                           [(JSON..=) "ScanEc2InstanceWithFindings"
                              Prelude.<$> scanEc2InstanceWithFindings])}
instance JSON.ToJSON CFNMalwareProtectionConfigurationProperty where
  toJSON CFNMalwareProtectionConfigurationProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes
              [(JSON..=) "ScanEc2InstanceWithFindings"
                 Prelude.<$> scanEc2InstanceWithFindings]))
instance Property "ScanEc2InstanceWithFindings" CFNMalwareProtectionConfigurationProperty where
  type PropertyType "ScanEc2InstanceWithFindings" CFNMalwareProtectionConfigurationProperty = CFNScanEc2InstanceWithFindingsConfigurationProperty
  set newValue CFNMalwareProtectionConfigurationProperty {..}
    = CFNMalwareProtectionConfigurationProperty
        {scanEc2InstanceWithFindings = Prelude.pure newValue, ..}