module Stratosphere.FSx.DataRepositoryAssociation.AutoImportPolicyProperty (
        AutoImportPolicyProperty(..), mkAutoImportPolicyProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Value
data AutoImportPolicyProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-autoimportpolicy.html>
    AutoImportPolicyProperty {haddock_workaround_ :: (),
                              -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-datarepositoryassociation-autoimportpolicy.html#cfn-fsx-datarepositoryassociation-autoimportpolicy-events>
                              events :: (ValueList Prelude.Text)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkAutoImportPolicyProperty ::
  ValueList Prelude.Text -> AutoImportPolicyProperty
mkAutoImportPolicyProperty events
  = AutoImportPolicyProperty
      {haddock_workaround_ = (), events = events}
instance ToResourceProperties AutoImportPolicyProperty where
  toResourceProperties AutoImportPolicyProperty {..}
    = ResourceProperties
        {awsType = "AWS::FSx::DataRepositoryAssociation.AutoImportPolicy",
         supportsTags = Prelude.False,
         properties = ["Events" JSON..= events]}
instance JSON.ToJSON AutoImportPolicyProperty where
  toJSON AutoImportPolicyProperty {..}
    = JSON.object ["Events" JSON..= events]
instance Property "Events" AutoImportPolicyProperty where
  type PropertyType "Events" AutoImportPolicyProperty = ValueList Prelude.Text
  set newValue AutoImportPolicyProperty {..}
    = AutoImportPolicyProperty {events = newValue, ..}