module Stratosphere.Connect.EvaluationForm.NumericQuestionPropertyValueAutomationProperty (
        NumericQuestionPropertyValueAutomationProperty(..),
        mkNumericQuestionPropertyValueAutomationProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Value
data NumericQuestionPropertyValueAutomationProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-numericquestionpropertyvalueautomation.html>
    NumericQuestionPropertyValueAutomationProperty {haddock_workaround_ :: (),
                                                    -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-numericquestionpropertyvalueautomation.html#cfn-connect-evaluationform-numericquestionpropertyvalueautomation-label>
                                                    label :: (Value Prelude.Text)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkNumericQuestionPropertyValueAutomationProperty ::
  Value Prelude.Text
  -> NumericQuestionPropertyValueAutomationProperty
mkNumericQuestionPropertyValueAutomationProperty label
  = NumericQuestionPropertyValueAutomationProperty
      {haddock_workaround_ = (), label = label}
instance ToResourceProperties NumericQuestionPropertyValueAutomationProperty where
  toResourceProperties
    NumericQuestionPropertyValueAutomationProperty {..}
    = ResourceProperties
        {awsType = "AWS::Connect::EvaluationForm.NumericQuestionPropertyValueAutomation",
         supportsTags = Prelude.False, properties = ["Label" JSON..= label]}
instance JSON.ToJSON NumericQuestionPropertyValueAutomationProperty where
  toJSON NumericQuestionPropertyValueAutomationProperty {..}
    = JSON.object ["Label" JSON..= label]
instance Property "Label" NumericQuestionPropertyValueAutomationProperty where
  type PropertyType "Label" NumericQuestionPropertyValueAutomationProperty = Value Prelude.Text
  set newValue NumericQuestionPropertyValueAutomationProperty {..}
    = NumericQuestionPropertyValueAutomationProperty
        {label = newValue, ..}