module Stratosphere.CodePipeline.Pipeline.RuleDeclarationProperty (
        module Exports, RuleDeclarationProperty(..),
        mkRuleDeclarationProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.CodePipeline.Pipeline.InputArtifactProperty as Exports
import {-# SOURCE #-} Stratosphere.CodePipeline.Pipeline.RuleTypeIdProperty as Exports
import Stratosphere.ResourceProperties
import Stratosphere.Value
data RuleDeclarationProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html>
    RuleDeclarationProperty {haddock_workaround_ :: (),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-commands>
                             commands :: (Prelude.Maybe (ValueList Prelude.Text)),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-configuration>
                             configuration :: (Prelude.Maybe JSON.Object),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-inputartifacts>
                             inputArtifacts :: (Prelude.Maybe [InputArtifactProperty]),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-name>
                             name :: (Prelude.Maybe (Value Prelude.Text)),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-region>
                             region :: (Prelude.Maybe (Value Prelude.Text)),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-rolearn>
                             roleArn :: (Prelude.Maybe (Value Prelude.Text)),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-ruletypeid>
                             ruleTypeId :: (Prelude.Maybe RuleTypeIdProperty)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkRuleDeclarationProperty :: RuleDeclarationProperty
mkRuleDeclarationProperty
  = RuleDeclarationProperty
      {haddock_workaround_ = (), commands = Prelude.Nothing,
       configuration = Prelude.Nothing, inputArtifacts = Prelude.Nothing,
       name = Prelude.Nothing, region = Prelude.Nothing,
       roleArn = Prelude.Nothing, ruleTypeId = Prelude.Nothing}
instance ToResourceProperties RuleDeclarationProperty where
  toResourceProperties RuleDeclarationProperty {..}
    = ResourceProperties
        {awsType = "AWS::CodePipeline::Pipeline.RuleDeclaration",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes
                           [(JSON..=) "Commands" Prelude.<$> commands,
                            (JSON..=) "Configuration" Prelude.<$> configuration,
                            (JSON..=) "InputArtifacts" Prelude.<$> inputArtifacts,
                            (JSON..=) "Name" Prelude.<$> name,
                            (JSON..=) "Region" Prelude.<$> region,
                            (JSON..=) "RoleArn" Prelude.<$> roleArn,
                            (JSON..=) "RuleTypeId" Prelude.<$> ruleTypeId])}
instance JSON.ToJSON RuleDeclarationProperty where
  toJSON RuleDeclarationProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes
              [(JSON..=) "Commands" Prelude.<$> commands,
               (JSON..=) "Configuration" Prelude.<$> configuration,
               (JSON..=) "InputArtifacts" Prelude.<$> inputArtifacts,
               (JSON..=) "Name" Prelude.<$> name,
               (JSON..=) "Region" Prelude.<$> region,
               (JSON..=) "RoleArn" Prelude.<$> roleArn,
               (JSON..=) "RuleTypeId" Prelude.<$> ruleTypeId]))
instance Property "Commands" RuleDeclarationProperty where
  type PropertyType "Commands" RuleDeclarationProperty = ValueList Prelude.Text
  set newValue RuleDeclarationProperty {..}
    = RuleDeclarationProperty {commands = Prelude.pure newValue, ..}
instance Property "Configuration" RuleDeclarationProperty where
  type PropertyType "Configuration" RuleDeclarationProperty = JSON.Object
  set newValue RuleDeclarationProperty {..}
    = RuleDeclarationProperty
        {configuration = Prelude.pure newValue, ..}
instance Property "InputArtifacts" RuleDeclarationProperty where
  type PropertyType "InputArtifacts" RuleDeclarationProperty = [InputArtifactProperty]
  set newValue RuleDeclarationProperty {..}
    = RuleDeclarationProperty
        {inputArtifacts = Prelude.pure newValue, ..}
instance Property "Name" RuleDeclarationProperty where
  type PropertyType "Name" RuleDeclarationProperty = Value Prelude.Text
  set newValue RuleDeclarationProperty {..}
    = RuleDeclarationProperty {name = Prelude.pure newValue, ..}
instance Property "Region" RuleDeclarationProperty where
  type PropertyType "Region" RuleDeclarationProperty = Value Prelude.Text
  set newValue RuleDeclarationProperty {..}
    = RuleDeclarationProperty {region = Prelude.pure newValue, ..}
instance Property "RoleArn" RuleDeclarationProperty where
  type PropertyType "RoleArn" RuleDeclarationProperty = Value Prelude.Text
  set newValue RuleDeclarationProperty {..}
    = RuleDeclarationProperty {roleArn = Prelude.pure newValue, ..}
instance Property "RuleTypeId" RuleDeclarationProperty where
  type PropertyType "RuleTypeId" RuleDeclarationProperty = RuleTypeIdProperty
  set newValue RuleDeclarationProperty {..}
    = RuleDeclarationProperty {ruleTypeId = Prelude.pure newValue, ..}