module Stratosphere.CodeDeploy.DeploymentGroup.TriggerConfigProperty (
        TriggerConfigProperty(..), mkTriggerConfigProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Value
data TriggerConfigProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html>
    TriggerConfigProperty {haddock_workaround_ :: (),
                           -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents>
                           triggerEvents :: (Prelude.Maybe (ValueList Prelude.Text)),
                           -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername>
                           triggerName :: (Prelude.Maybe (Value Prelude.Text)),
                           -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn>
                           triggerTargetArn :: (Prelude.Maybe (Value Prelude.Text))}
  deriving stock (Prelude.Eq, Prelude.Show)
mkTriggerConfigProperty :: TriggerConfigProperty
mkTriggerConfigProperty
  = TriggerConfigProperty
      {haddock_workaround_ = (), triggerEvents = Prelude.Nothing,
       triggerName = Prelude.Nothing, triggerTargetArn = Prelude.Nothing}
instance ToResourceProperties TriggerConfigProperty where
  toResourceProperties TriggerConfigProperty {..}
    = ResourceProperties
        {awsType = "AWS::CodeDeploy::DeploymentGroup.TriggerConfig",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes
                           [(JSON..=) "TriggerEvents" Prelude.<$> triggerEvents,
                            (JSON..=) "TriggerName" Prelude.<$> triggerName,
                            (JSON..=) "TriggerTargetArn" Prelude.<$> triggerTargetArn])}
instance JSON.ToJSON TriggerConfigProperty where
  toJSON TriggerConfigProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes
              [(JSON..=) "TriggerEvents" Prelude.<$> triggerEvents,
               (JSON..=) "TriggerName" Prelude.<$> triggerName,
               (JSON..=) "TriggerTargetArn" Prelude.<$> triggerTargetArn]))
instance Property "TriggerEvents" TriggerConfigProperty where
  type PropertyType "TriggerEvents" TriggerConfigProperty = ValueList Prelude.Text
  set newValue TriggerConfigProperty {..}
    = TriggerConfigProperty {triggerEvents = Prelude.pure newValue, ..}
instance Property "TriggerName" TriggerConfigProperty where
  type PropertyType "TriggerName" TriggerConfigProperty = Value Prelude.Text
  set newValue TriggerConfigProperty {..}
    = TriggerConfigProperty {triggerName = Prelude.pure newValue, ..}
instance Property "TriggerTargetArn" TriggerConfigProperty where
  type PropertyType "TriggerTargetArn" TriggerConfigProperty = Value Prelude.Text
  set newValue TriggerConfigProperty {..}
    = TriggerConfigProperty
        {triggerTargetArn = Prelude.pure newValue, ..}