{-# LANGUAGE OverloadedStrings #-}

module Main where

import System.Exit (exitFailure, exitSuccess)
import Test.HUnit hiding (Node)

import qualified Data.Text.Lazy as T
import Nauty.Sparse6.Internal


testParsing :: AdjacencyList -> T.Text -> IO ()
testParsing g str = do
  assertEqual ("parse " ++ T.unpack str) ([Right g]) (parse str)
  assertEqual ("encode " ++ T.unpack str) str (encode g)

tests :: Test
tests = TestList                         
  [ TestLabel "g = parse $ encode g" $ TestCase
    ( do 
      let g0 = fromEdgeList 4 [(1,0), (2,1), (3,2), (3,0)]
      assertEqual (T.unpack $ encode g0)
        ([Right g0])
        (parse $ encode g0)
      -- :D
      -- 1 000 1 001
      -- 100010 011111 
      -- 34     31   
      -- a      ^
      testParsing (fromEdgeList 5 [(1,0), (2,1)])
                  ":Da^"
      -- :D
      -- 1 000 1 001 1 010 1 011 
      -- 100010 011010 101111
      -- 34     26     47   
      -- a      Y      n
      testParsing (fromEdgeList 5 [(1,0), (2,1), (3,2), (4,3)])
                  ":DaYn"
      -- :D
      -- 1 000 1 001 1 010 1 011 0 000
      -- 100010 011010 101100 001111
      -- 34     26     44     15
      -- a      Y      k      N
      testParsing (fromEdgeList 5 [(1,0), (2,1), (3,2), (4,3), (4,0)])
                  ":DaYkN"
      let g1 = fromEdgeList 10 [(1,0), (2,1), (3,2), (4,3), (5,4), (6,5), (7,6), (8,7), (9,8), (9,0)]
      assertEqual (T.unpack $ encode g1)
        ([Right g1])
        (parse $ encode g1)
      testParsing (fromEdgeList 1 [])
                  ":@"
    )
  , TestLabel "invalid characters" $ TestCase
    ( do 
      -- :D
      -- 0 010 0 000 0 100 0 001 0 010
      -- 001000 000100 000100 101111
      -- 8      4      4      47
      -- G      C      C      n
      testParsing (fromEdgeList 5 [(2,0), (4,1), (4,2)])
                  ":DGCCn"
    )
  , TestLabel "encodeVertex'" $ TestCase
    ( do 
      assertEqual ""
        ([4], 2 , 2)
        (encodeVertex' 2 3 [] 2 5)
    )
  ]

main :: IO ()
main = do 
  count <- runTestTT tests
  if errors count + failures count > 0 then exitFailure else exitSuccess
