{-|
Module      : Nauty
Description : General encoding and decoding.
Copyright   : (c) Marcelo Garlet Milani, 2026
License     : MIT
Maintainer  : mgmilani@pm.me
Stability   : stable

This module functions for encoding and decoding graphs in any of the supported formats.
In particular, `encodeMany` is capable of using the incremental @sparse6@ format as well.

If you want instead to work with a specific format, use "Nauty.Graph6", "Nauty.Sparse6" or "Nauty.Digraph6" instead.
-}

module Nauty
        ( 
        -- * Graph structure
          Graph(..)
        , GraphType(..)
        , edgeExists
        , toEdgeList
        -- * Parsing
        , Format(..)
        , parse
        , parse'
        -- * Encoding
        , encode
        , encodeMany
        , encodeMany'
        )
where

import Nauty.Internal

