module KB.Text.Shape.FFI.Handles where

import Foreign
import Data.Coerce (Coercible, coerce)

#include "kb_text_shape.h"

{-# INLINE intHandle #-}
intHandle :: Coercible h (Ptr a) => h -> Int
intHandle ptrLike = i
  where
   IntPtr i = ptrToIntPtr (coerce ptrLike)

-- | An opaque handle to the shaping context..
newtype ShapeContext = ShapeContext (Ptr ShapeContext)
  deriving (Eq, Ord, Show)
  deriving newtype (Storable)

-- | An opaque handle to the font data.
newtype Font = Font (Ptr Font)
  deriving (Eq, Ord, Show)
  deriving newtype (Storable)

{- | Amount of bytes needed to hold the font data structure

Usually you don't have to look inside, but may have to allocate one to get the 'Font' handle.
-}
sizeOfFontData :: Int
sizeOfFontData = #size kbts_font

newtype ShapeConfig = ShapeConfig (Ptr ShapeConfig)
  deriving (Eq, Ord, Show)
  deriving newtype (Storable)

newtype GlyphConfig = GlyphConfig (Ptr GlyphConfig)
  deriving (Eq, Ord, Show)
  deriving newtype (Storable)

newtype BreakState = BreakState (Ptr BreakState)
  deriving (Eq, Ord, Show)
  deriving newtype (Storable)
