module KB.Text.Shape.FFI.API.Direct where

import Prelude hiding (id, error)

import Foreign
import Foreign.C

import KB.Text.Shape.FFI.Allocator (Allocator)
import KB.Text.Shape.FFI.Handles
import KB.Text.Shape.FFI.Enums
import KB.Text.Shape.FFI.Structs

#include "kb_text_shape.h"

-- | @kbts_shape_error kbts_ShapeDirect(kbts_shape_config *Config, kbts_glyph_storage *Storage, kbts_direction RunDirection, kbts_allocator_function *Allocator, void *AllocatorData, kbts_glyph_iterator *Output);@
foreign import ccall safe "kbts_ShapeDirect" kbts_ShapeDirect
  :: ShapeConfig
  -> Ptr GlyphStorage
  -> Direction
  -> FunPtr Allocator
  -> Ptr ()
  -> Ptr GlyphIterator
  -> IO ShapeError

-- | @kbts_shape_error kbts_ShapeDirectFixedMemory(kbts_shape_config *Config, kbts_glyph_storage *Storage, kbts_direction RunDirection, void *Memory, int MemorySize, kbts_glyph_iterator *Output);@
foreign import ccall unsafe "kbts_ShapeDirectFixedMemory" kbts_ShapeDirectFixedMemory
  :: ShapeConfig
  -> Ptr GlyphStorage
  -> Direction -- ^ RunDirection
  -> Ptr () -- ^ Memory
  -> CInt -- ^ MemorySize
  -> IO ShapeError

-- A font holds all data that corresponds to a given font file.

#ifndef KB_TEXT_SHAPE_NO_CRT
-- | @kbts_font kbts_FontFromFile(const char *FileName, int FontIndex, kbts_allocator_function *Allocator, void *AllocatorData, void **FileData, int *FileSize);@
foreign import ccall safe "hs_FontFromFile" hs_FontFromFile
  :: Ptr CChar -- ^ FileName
  -> CInt -- ^ FontIndex
  -> FunPtr Allocator
  -> Ptr () -- ^ AllocatorData
  -> Ptr (Ptr ()) -- ^ FileData
  -> Ptr CInt -- ^ FileSize
  -> Ptr Font
  -> IO LoadFontError
#endif

-- | @int kbts_FontCount(void *FileData, int FileSize);@
foreign import ccall unsafe "kbts_FontCount" kbts_FontCount
  :: Ptr () -- ^ FileData
  -> CInt -- ^ FileSize
  -> CInt

-- | @kbts_font kbts_FontFromMemory(void *FileData, int FileSize, int FontIndex, kbts_allocator_function *Allocator, void *AllocatorData);@
foreign import ccall safe "hs_FontFromMemory" hs_FontFromMemory
  :: Ptr () -- ^ FileData
  -> CInt -- ^ FileSize
  -> CInt -- ^ FontIndex
  -> FunPtr Allocator
  -> Ptr () -- ^ AllocatorData
  -> Font
  -> IO LoadFontError

-- | @void kbts_FreeFont(kbts_font *Font);@
foreign import ccall safe "kbts_FreeFont" kbts_FreeFont
  :: Font
  -> IO ()

-- | @int kbts_FontIsValid(kbts_font *Font);@
foreign import ccall unsafe "kbts_FontIsValid" kbts_FontIsValid
  :: Font
  -> CInt

-- | Opaque token for @kbts_load_font_state@
data LoadFontState = LoadFontState -- XXX: neither a struct, nor a handle
{-
  void *FontData;
  kbts_u32 FontDataSize;

  kbts_blob_table Tables[KBTS_BLOB_TABLE_ID_COUNT];
  kbts_u32 LookupCount;
  kbts_u32 LookupSubtableCount;
  kbts_u32 GlyphCount;
  kbts_u32 ScratchSize;

  kbts_u32 GlyphLookupMatrixSizeInBytes;
  kbts_u32 GlyphLookupSubtableMatrixSizeInBytes;
  kbts_u32 TotalSize;
-}
  deriving (Show)

instance Storable LoadFontState where
  alignment ~_ = #alignment kbts_load_font_state
  sizeOf ~_ = #size kbts_load_font_state
  peek _ptr = pure LoadFontState
  poke ptr LoadFontState{} = fillBytes ptr 0x00 (#size kbts_load_font_state)

-- | @kbts_load_font_error kbts_LoadFont(kbts_font *Font, kbts_load_font_state *State, void *FontData, int FontDataSize, int FontIndex, int *ScratchSize_, int *OutputSize_);@
foreign import ccall unsafe "kbts_LoadFont" kbts_LoadFont
  :: Font
  -> Ptr LoadFontState
  -> Ptr () -- ^ FontData
  -> CInt -- ^ FontDataSize
  -> CInt -- ^ FontIndex
  -> Ptr Int -- ^ ScratchSize_
  -> Ptr Int -- ^ OutputSize_
  -> IO LoadFontError

-- | @kbts_load_font_error kbts_PlaceBlob(kbts_font *Font, kbts_load_font_state *State, void *ScratchMemory, void *OutputMemory);@
foreign import ccall unsafe "kbts_PlaceBlob" kbts_PlaceBlob
  :: Font
  -> Ptr LoadFontState
  -> Ptr () -- ^ ScratchMemory
  -> Ptr () -- ^ OutputMemory
  -> IO LoadFontError

-- | @void kbts_GetFontInfo(kbts_font *Font, kbts_font_info *Info);@
foreign import ccall unsafe "kbts_GetFontInfo" kbts_GetFontInfo
  :: Font
  -> Ptr FontInfo
  -> IO ()

-- A shape_config is a bag of pre-computed data for a specific shaping setup.

-- | @int kbts_SizeOfShapeConfig(kbts_font *Font, kbts_script Script, kbts_language Language);@
foreign import ccall unsafe "kbts_SizeOfShapeConfig" kbts_SizeOfShapeConfig
  :: Font
  -> Script
  -> Language
  -> CInt

-- | @kbts_shape_config *kbts_PlaceShapeConfig(kbts_font *Font, kbts_script Script, kbts_language Language, void *Memory);@
foreign import ccall unsafe "kbts_PlaceShapeConfig" kbts_PlaceShapeConfig
  :: Font
  -> Script
  -> Language
  -> Ptr () -- ^ Memory
  -> IO ShapeConfig

-- | @kbts_shape_config *kbts_CreateShapeConfig(kbts_font *Font, kbts_script Script, kbts_language Language, kbts_allocator_function *Allocator, void *AllocatorData);@
foreign import ccall unsafe "kbts_CreateShapeConfig" kbts_CreateShapeConfig
  :: Font
  -> Script
  -> Language
  -> FunPtr Allocator
  -> Ptr ()
  -> IO ShapeConfig

-- | @void kbts_DestroyShapeConfig(kbts_shape_config *Config);@
foreign import ccall unsafe "kbts_DestroyShapeConfig" kbts_DestroyShapeConfig
  :: ShapeConfig
  -> IO ()

-- A glyph_storage holds and recycles glyph data.

-- | @int kbts_InitializeGlyphStorage(kbts_glyph_storage *Storage, kbts_allocator_function *Allocator, void *AllocatorData)@
foreign import ccall unsafe "kbts_InitializeGlyphStorage" kbts_InitializeGlyphStorage
  :: Ptr GlyphStorage
  -> FunPtr Allocator
  -> Ptr () -- ^ AllocatorData
  -> IO Int

-- | @int kbts_InitializeGlyphStorageFixedMemory(kbts_glyph_storage *Storage, void *Memory, int MemorySize);@
foreign import ccall unsafe "kbts_InitializeGlyphStorageFixedMemory" kbts_InitializeGlyphStorageFixedMemory
  :: Ptr GlyphStorage
  -> Ptr () -- ^ Memory
  -> CInt -- ^ MemorySize
  -> IO Int

-- | @kbts_glyph *kbts_PushGlyph(kbts_glyph_storage *Storage, kbts_font *Font, int Codepoint, kbts_glyph_config *Config, int UserId);@
foreign import ccall unsafe "kbts_PushGlyph" kbts_PushGlyph
  :: Ptr GlyphStorage
  -> Font
  -> CInt -- ^ Codepoint
  -> GlyphConfig
  -> CInt
  -> IO (Ptr Glyph)

-- | @void kbts_ClearActiveGlyphs(kbts_glyph_storage *Storage);@
foreign import ccall unsafe "kbts_ClearActiveGlyphs" kbts_ClearActiveGlyphs
  :: Ptr GlyphStorage
  -> IO ()

-- | @void kbts_FreeAllGlyphs(kbts_glyph_storage *Storage);@
foreign import ccall unsafe "kbts_FreeAllGlyphs" kbts_FreeAllGlyphs
  :: Ptr GlyphStorage
  -> IO ()

-- | Wrapped @kbts_glyph kbts_CodepointToGlyph(kbts_font *Font, int Codepoint, kbts_glyph_config *Config, int UserId);@
--
-- The original returns struct by value.
foreign import ccall unsafe "hs_CodepointToGlyph" hs_CodepointToGlyph
  :: Font
  -> CInt -- ^ Codepoint
  -> GlyphConfig
  -> CInt -- ^ UserId
  -> Ptr Glyph
  -> IO ()

-- | @int kbts_CodepointToGlyphId(kbts_font *Font, int Codepoint);@
foreign import ccall unsafe "kbts_CodepointToGlyphId" kbts_CodepointToGlyphId
  :: Font
  -> CInt -- ^ Codepoint
  -> IO Int

-- | Wrapped @kbts_glyph_iterator kbts_ActiveGlyphIterator(kbts_glyph_storage *Storage);@
--
-- The original returns struct by value.
foreign import ccall unsafe "hs_ActiveGlyphIterator" hs_ActiveGlyphIterator
  :: Ptr GlyphStorage
  -> Ptr GlyphIterator
  -> IO ()

-- A glyph_config specifies glyph-specific shaping parameters.
--
-- A single glyph_config can be shared by multiple glyphs.

-- | @int kbts_SizeOfGlyphConfig(kbts_feature_override *Overrides, int OverrideCount);@
foreign import ccall unsafe "kbts_SizeOfGlyphConfig" kbts_SizeOfGlyphConfig
  :: Ptr FeatureOverride
  -> CInt -- ^ OverrideCount
  -> CInt

-- | @kbts_glyph_config *kbts_PlaceGlyphConfig(kbts_feature_override *Overrides, int OverrideCount, void *Memory);@
foreign import ccall unsafe "kbts_PlaceGlyphConfig" kbts_PlaceGlyphConfig
  :: Ptr FeatureOverride
  -> CInt -- ^ OverriderCount
  -> Ptr () -- ^ Memory
  -> IO GlyphConfig

-- | @kbts_glyph_config *kbts_CreateGlyphConfig(kbts_feature_override *Overrides, int OverrideCount, kbts_allocator_function *Allocator, void *AllocatorData);@
foreign import ccall safe "kbts_CreateGlyphConfig" kbts_CreateGlyphConfig
  :: Ptr FeatureOverride
  -> CInt -- ^ OverrideCount
  -> FunPtr Allocator
  -> Ptr () -- ^ AllocatorData
  -> IO GlyphConfig

-- | @void kbts_DestroyGlyphConfig(kbts_glyph_config *Config);@
foreign import ccall unsafe "kbts_DestroyGlyphConfig" kbts_DestroyGlyphConfig
  :: GlyphConfig
  -> IO ()
