--
module Test.MUnit (assertEqualM)
where

    import Data.List.Split (splitOn)
    import Control.Exception (catch)
    import GHC.Exception.Type (SomeException)

    assertEqualM :: (Eq a, Show a) => String -> a -> IO a -> IO ()
    assertEqualM message expected actualM =
        catch
            (actualM >>= assertEqual0 message expected)
            handle

    assertEqual0 :: (Eq a, Show a) => String -> a -> a -> IO ()
    assertEqual0 message expected actual =
        if expected == actual
            then putStrLn (show actual ++ " == " ++ show expected ++ " -- " ++ message)
            else putStrLn (show actual ++ " /= " ++ show expected ++ " -- " ++ message)

    handle :: SomeException -> IO ()
    handle someException =
        putStrLn (dropWhile ((==)' ') (last (splitOn "\n" (show someException))))

--
