---
-- $ greeter greet [<greetee>]
-- $ source <(greeter --completion)
-- $ greeter --version
-- $ greeter --how
---
module Main (main)
where

    import System.Environment (getArgs)
    import System.Exiter (exit)
    import Control.Greeter.Anonymous (anonymousGreetingM)
    import Control.Greeter.Onymous (onymousGreetingM)
    import Control.Greeter.Common (greetingM)

--
    main :: IO ()
    main = getArgs >>= processing

--
    processing :: [String] -> IO ()
    processing arguments =
        case arguments of
            []                         -> exit 1 "greeter: missing verb"
            "greet"       : []         -> anonymousGreetingM >>= greetingM
            "greet"       : greetee: _ -> onymousGreetingM greetee >>= greetingM
            "--completion": _          -> putStrLn completion
            "--version"   : _          -> putStrLn version
            "--how"       : _          -> putStrLn how
            _                          -> exit 2 "greeter: unknown verb"

--
    how :: String
    how = "---\n-- $ greeter greet [<greetee>]\n-- $ source <(greeter --completion)\n-- $ greeter --version\n-- $ greeter --how\n---"

--
    version :: String
    version = "0.0.3"

--
    completion :: String
    completion = "#!/bin/bash\ncomplete -W 'greet --how --version --completion' greeter"

--
