module Main (main) where

import           Codec.Bz3
import qualified Data.ByteString.Lazy as BSL
import           System.Directory     (doesDirectoryExist, listDirectory)
import           Test.Tasty           (defaultMain, testGroup)
import           Test.Tasty.HUnit     (assertBool, testCase)

main :: IO ()
main = do
    d <- do {e <- doesDirectoryExist "test/data"; if e then listDirectory "test/data" else pure []}
    defaultMain $ testGroup "bz3" [ roundtrip ("test/data/" ++ f) | f <- d ]

roundtrip fp = testCase ("roundtrip " ++ fp) $ do
    contents <- BSL.readFile fp
    let d = decompressFile contents
        e = compressFile d
        d1 = decompressFile e
    assertBool "doesn't error" (d1 `seq` True)
