module Codec.Bz3.Foreign ( Bz3St
                         , Bz3Error (..)
                         , bz3New
                         , bz3Free
                         , bz3Bound
                         , bz3Strerror
                         , bz3DecodeBlock
                         , bz3EncodeBlock
                         ) where

import Data.Int (Int32)
import Foreign.Ptr (Ptr)
import Foreign.C.Types (CSize)

#include<libbz3.h>

{# enum define Bz3Error { BZ3_OK as Bz3Ok
                        , BZ3_ERR_OUT_OF_BOUNDS as Bz3ErrOutOfBounds
                        , BZ3_ERR_BWT as Bz3ErrBwt
                        , BZ3_ERR_CRC as Bz3ErrCrc
                        , BZ3_ERR_MALFORMED_HEADER as Bz3ErrMalformedHeader
                        , BZ3_ERR_TRUNCATED_DATA as Bz3ErrTruncatedData
                        , BZ3_ERR_DATA_TOO_BIG as Bz3ErrDataTooBig
                        , BZ3_ERR_INIT as Bz3ErrInit
                        } deriving (Eq)
  #}

data Bz3St

{# pointer *bz3_state as Bz3StPtr foreign finalizer bz3_free as ^ -> Bz3St #}

type UInt8 = {# type uint8_t #}
{#typedef uint8_t UInt8#}
{#default in `Ptr UInt8' [uint8_t*] id#}

{#typedef int32_t Int32#}

{#typedef size_t CSize#}
{#default in `Ptr CSize' [size_t*] id#}

{# fun bz3_new as ^ { `Int32' } -> `Ptr Bz3St' id #}
{# fun pure bz3_bound as ^ { `CSize' } -> `CSize' #}
{# fun bz3_strerror as ^ { `Bz3StPtr' } -> `String' #}
{# fun bz3_decode_block as ^ { `Bz3StPtr', `Ptr UInt8', `CSize', `Int32', `Int32' } -> `Either Bz3Error Int32' bz3Err #}
{# fun bz3_encode_block as ^ { `Bz3StPtr', `Ptr UInt8', `Int32' } -> `Int32' #}

bz3Err :: Int32 -> Either Bz3Error Int32
bz3Err i | i > 0 = Right i
         | otherwise = Left$toEnum (fromIntegral i)
