# align-equal

This project is based on an idea from Gabriella Gonzalez.  
For more details, visit: [Gabriella's blog](https://www.haskellforall.com/2018/10/detailed-walkthrough-for-beginner.html)

`align-equal` is a command-line tool that aligns text based on the `=` symbol.  
It ensures that all `=` signs are vertically aligned, improving readability.

This program reads text from **standard input**, processes it, and outputs the aligned result to **standard output**.

## Installation

To install `align-equal` using `cabal`, run:

```sh
cabal install align-equal
```

## Usage

### **Using in Vim**

`align-equal` is primarily designed for use within Vim. You can align selected text in **visual mode** as follows:

1. Select the lines you want to align in **visual mode** (`V` for line-wise selection).
2. Run:  
   ```vim
   :!align-equal
   ```
3. The selected text will be replaced with an aligned version.

#### **Example**

**Before (Selected Text in Visual Mode)**:
```vim
x = 1
longVariable = 2
short = 3
```

**Command**:
```vim
:!align-equal
```

**After**:
```vim
x            = 1
longVariable = 2
short        = 3
```

## How it Works

`align-equal` scans the input, detects `=` symbols, and aligns them by adding the appropriate amount of whitespace.
