# Changelog
All notable changes to the `align-equal` project will be documented in this file.

## [0.1.1.1] - 2025-03-31
### Added  
- Expanded `README.md` with a detailed description of the tool.  
- Included Vim usage instructions with examples.  

### Miscellaneous  
- Bumped version to `0.1.1.1` in `align-equal.cabal`.  

## [0.1.1.0] - 2025-03-27
- **Added**: Extracted core functions into a separate library module (`Data.Text.AlignEqual`).
  - Refactored original `Main.hs` into executable and library components.
  - Added `src/Data/Text/AlignEqual.hs` with core text alignment logic.
  - Updated `app/Main.hs` to import and use `Data.Text.AlignEqual`.
  - Adjusted `.cabal` file to include a new library section and dependencies.
- **Added**: Haddock documentation for `Data.Text.AlignEqual`.
  - Documented module purpose, `prefixLength`, `adjustLine`, and `adjustText` with descriptions, examples, and parameter annotations.
- **Added**: Included `CHANGELOG.md` in the package documentation via `extra-doc-files` in `.cabal`.
- **Maintained**: Compatibility with the existing executable.

## [0.1.0.1] - 2025-03-10
- **Fixed**: Relaxed `base` dependency constraint to `>=4.17 && <4.19`.
- **Fixed**: Removed duplicate `extra-doc-files` entry in `.cabal` file.
- **Added**: `README.md` with credit to Gabriella Gonzalez.
- **Added**: Source repository link to `hub.darcs.net` in `.cabal` file.

## [0.1.0.0] - 2025-03-10
- **Initial Release**: Basic functionality for aligning text with equal signs.
  - Implemented as a standalone executable in `Main.hs`.
  - Initial project setup with `.cabal` and `LICENSE` files.
