# Edison

Changelog of EdisonAPI and EdisonCore.

[Latest CHANGES.md](https://github.com/robdockins/edison/blob/master/CHANGES.md)

## 1.3.3.2
* Compatibility with GHC 9.10 and 9.12

## 1.3.3.1
* Remove mtl dependency (removed unnecessary imports which were incompatible with mtl 2.3)
* Fix implementation of little-endian PatriciaTrees

## 1.3.3
* Updates to handle MonadFail changes in GHC 8.x
* Updates to fix compile issues in GHC 9

## 1.3.2.1
* Fix compile problems on GHC 7.10

## 1.3.2
* Add Semigroup instances for all types that previously had Monoid instances.
* Remove use of depreciated functions in Data.Edison.Assoc.StandardMap

## 1.3.1
* Remove Arbitrary and Coarbitrary instances for Data.Set
     and Data.Map.  These are now provided by QuickCheck >= 2.8.2

## 1.3
* Updates to compile with GHC 7.10
    - Added Applicative and Alternative instances as required
    - Disambiguate the types of some operations
    - Resolve namespace clashes
* Added stack.yaml file to build with stack

## 1.2.2
  * Update edison-core to use QuickCheck version 2.*
  * Likewise update the test suite

## 1.2.1.3
* Minor fix to the StandardMap module to handle the API change in GHC 6.10

## 1.2.1.2
* Build system changes to remove mostly-superfulous dependency on
    haskell98, and to force dependence on the 1.x branch of QuickCheck.

## 1.2.1.1
* Build system changes to make GHC 6.8 and cabal >= 1.2.2 happy

## 1.2.1
* New sequence implementation based on Finger Trees
* Add the 'Measured' class to the Data.Edison.Prelude
* Addition of methods to EnumSet to project to a bit-encoded word and to
    create an EnumSet from a bit-encoded word
* Additional minor changes to EnumSet
* Fix a boneheaded mistake I made where I claimed most of Edison was
    licensed under BSD3, when it is in fact licensed under the MIT license.
    The practical differences are minor, and I hope this will not cause too
    many problems.

## 1.2.0.1
* Change use more efficient operations for StandardSet.{filterGT,filterLT}
    and StandardMap.{filterLE,filterGE,partitionLE_GT,partitionLT_GE}

## 1.2 final
* Fix documentation for sequences to reflect correct
    time complexities

## 1.2rc4
* introduce strict/strictWith operations for all APIs
* add Ord* instances for PatriciaLoMap and TernaryTrie
* add David F. Place's EnumSet implementation
* complete the FiniteMap unit test coverage and fix a bunch
    of bugs in finite map implementations
* add 'symmetricDifference' to Collection and
    Associated Collection APIs
* add Ord instances for data structures
* add Monoid instances for data structures


## 1.2rc3
* introduce the ambiguous/unambiguous concept and document
    all API operations
* factor out methods which "mirror" superclass methods and
    make them alises instead
* add lookupAndDelete* methods to associated collections
* change the type of adjustOrDelete* in associated collections
* rename subset/subsetEq to properSubset/subset
* add matching Read and Show instances for all concrete datastructures
* add properSubmap{By} submap{By} and sameMap{By} to the
    associated collection API
* add Eq instances for concrete associated collections
* break out the test suite into a separate sub-package


## 1.2rc2
* add strict variants of all folds and reduces
* reverse argument orders to 'rcons' and 'lookup*' in Sequence
* add symbolic operators for lcons, rcons, append, and lookup
    from the Sequence API
* add symbolic operators for subsetEq, difference, intersection
    and union from the set API
* rename 'single' to 'singleton' in all APIs
* reaame 'intersect' to 'intersection' in Collection and
    Associated Collection APIs
* add 'adjustOrInsert' to the Associated Collection API


## 1.2rc1
* modules re-organized into a hierarchy
* user's guide distributed throughout source code as Haddock comments
* use cabal for build system
* add Data.Edison module to re-export typeclasses
* reorder 'lookup*' and 'find*' methods for
    Collections and Associated Collections
* add 'unsafeMapMonotonic' to main Collection API
* organize QuickCheck properties into a full test suite
* add a 'structuralInvariant' method to all APIs, for unit testing
